unit SQLite3Types;

interface

const
  SQLITE_OK = 0; // Successful result
  SQLITE_ERROR = 1; // SQL error or missing database
  SQLITE_INTERNAL = 2; // An internal logic error in SQLite
  SQLITE_PERM = 3; // Access permission denied
  SQLITE_ABORT = 4; // Callback routine requested an abort
  SQLITE_BUSY = 5; // The database file is locked
  SQLITE_LOCKED = 6; // A table in the database is locked
  SQLITE_NOMEM = 7; // A malloc() failed
  SQLITE_READONLY = 8; // Attempt to write a readonly database
  SQLITE_INTERRUPT = 9; // Operation terminated by sqlite_interrupt()
  SQLITE_IOERR = 10; // Some kind of disk I/O error occurred
  SQLITE_CORRUPT = 11; // The database disk image is malformed
  SQLITE_NOTFOUND = 12; // (Internal Only) Table or record not found
  SQLITE_FULL = 13; // Insertion failed because database is full
  SQLITE_CANTOPEN = 14; // Unable to open the database file
  SQLITE_PROTOCOL = 15; // Database lock protocol error
  SQLITE_EMPTY = 16; // Database is empty
  SQLITE_SCHEMA = 17; // The database schema changed
  SQLITE_TOOBIG = 18; // Too much data for one row of a table
  SQLITE_CONSTRAINT = 19; // Abort due to constraint violation
  SQLITE_MISMATCH = 20; // Data type mismatch
  SQLITE_MISUSE = 21; // Library used incorrectly
  SQLITE_NOLFS = 22; // Uses OS features not supported on host
  SQLITE_AUTH = 23; // Authorization denied
  SQLITE_FORMAT = 24; // Auxiliary database format error
  SQLITE_RANGE = 25; // 2nd parameter to sqlite3_bind out of range
  SQLITE_NOTADB = 26; // File opened that is not a database file

  SQLITE_ROW = 100; // sqlite_step() has another row ready
  SQLITE_DONE = 101; // sqlite_step() has finished executing

  { These are the allowed values for the eTextRep argument to
  sqlite3_create_collation and sqlite3_create_function. }
  SQLITE_UTF8 = 1;
  SQLITE_UTF16LE = 2;
  SQLITE_UTF16BE = 3;
  SQLITE_UTF16 = 4; { Use native byte order }
  SQLITE_ANY = 5;

  { values returned by sqlite3_column_type }
  SQLITE_INTEGER = 1;
  SQLITE_FLOAT = 2;
  SQLITE_TEXT = 3;
  SQLITE_BLOB = 4;
  SQLITE_NULL = 5;

  SQLITE_STATIC = nil;
  SQLITE_TRANSIENT = Pointer(-1);

type
  TProgressCallbackFunc = function(Obj: TObject): Integer; cdecl;
  Psqlite3_value = PPAnsiChar;

  TxFunc = procedure(db: Pointer; cArg: integer; ArgV: PPointerArray); cdecl;
  TxStep = procedure(db: Pointer; cArg: integer; ArgV: PPointerArray); cdecl;
  TxFinal = procedure(db: Pointer); cdecl;

  Psqlite3_api_routines = ^Tsqlite3_api_routines;
  Tsqlite3_api_routines = packed record
    sqlite3_aggregate_context: Pointer;
    sqlite3_aggregate_count: Pointer;
    sqlite3_bind_blob: function(hstatement: Pointer; ParamNum: Integer; ptrData: Pointer; numBytes: Integer; ptrDestructor: Pointer): Integer; cdecl;
    sqlite3_bind_double: function(hstatement: Pointer; ParamNum: Integer; Data: Double): Integer; cdecl;
    sqlite3_bind_int: function(hstatement: Pointer; ParamNum: Integer; Data: Integer): Integer; cdecl;
    sqlite3_bind_int64: function(hstatement: Pointer; ParamNum: Integer; Data: Int64): Integer; cdecl;
    sqlite3_bind_null: function(hstatement: Pointer; ParamNum: Integer): Integer; cdecl;
    sqlite3_bind_parameter_count: function(hstatement: Pointer): Integer; cdecl;
    sqlite3_bind_parameter_index: Pointer;
    sqlite3_bind_parameter_name: function(hstatement: Pointer; paramNo: Integer): PAnsiChar; cdecl;
    sqlite3_bind_text: function(hstatement: Pointer; ParamNum: Integer; ptrData: Pointer; numBytes: Integer; ptrDestructor: Pointer): Integer; cdecl;
    sqlite3_bind_text16: function(hstatement: Pointer; ParamNum: Integer; ptrData: Pointer; numBytes: Integer; ptrDestructor: Pointer): Integer; cdecl;
    sqlite3_bind_value: Pointer;
    sqlite3_busy_handler: procedure(db: Pointer; CallbackPtr: Pointer; Sender: TObject); cdecl;
    sqlite3_busy_timeout: procedure(db: Pointer; TimeOut: Integer); cdecl;
    sqlite3_changes: function(db: Pointer): Integer; cdecl;
    sqlite3_close: function(db: Pointer): Integer; cdecl;
    sqlite3_collation_needed: function(db: Pointer; pCollNeededArg: Pointer; CollationFunctionPtr: Pointer): Integer; cdecl;
    sqlite3_collation_needed16: function(db: Pointer; pCollNeededArg: Pointer; CollationFunctionPtr: Pointer): Integer; cdecl;
    sqlite3_column_blob: function(hstatement: Pointer; iCol: Integer): Pointer; cdecl;
    sqlite3_column_bytes: function(hstatement: Pointer; iCol: Integer): Integer; cdecl;
    sqlite3_column_bytes16: function(hstatement: Pointer; iCol: Integer): Integer; cdecl;
    sqlite3_column_count: function(hstatement: Pointer): Integer; cdecl;
    sqlite3_column_database_name: Pointer;
    sqlite3_column_database_name16: Pointer;
    sqlite3_column_decltype: function(hstatement: Pointer; iCol: Integer): PAnsiChar; cdecl;
    sqlite3_column_decltype16: function(hstatement: Pointer; iCol: Integer): PChar; cdecl;
    sqlite3_column_double: function(hstatement: Pointer; iCol: Integer): Double; cdecl;
    sqlite3_column_int: function(hstatement: Pointer; iCol: Integer): Integer; cdecl;
    sqlite3_column_int64: function(hstatement: Pointer; iCol: Integer): Int64; cdecl;
    sqlite3_column_name: function(hstatement: Pointer; iCol: Integer): PAnsiChar; cdecl;
    sqlite3_column_name16: function(hstatement: Pointer; iCol: Integer): PChar; cdecl;
    sqlite3_column_origin_name: Pointer;
    sqlite3_column_origin_name16: Pointer;
    sqlite3_column_table_name: Pointer;
    sqlite3_column_table_name16: Pointer;
    sqlite3_column_text: Pointer;
    sqlite3_column_text16: Pointer;
    sqlite3_column_type: Pointer;
    sqlite3_column_value: Pointer;
    sqlite3_commit_hook: Pointer;
    sqlite3_complete: Pointer;
    sqlite3_complete16: Pointer;
    sqlite3_create_collation: Pointer;
    sqlite3_create_collation16: Pointer;
    sqlite3_create_function: function(db: Pointer; functionName: PAnsiChar; nArg: integer; eTextRep: integer;
      pUserdata: Pointer; xFunc: TxFunc; xStep: TxStep; xFinal: TxFinal): integer; cdecl;
    sqlite3_create_function16: function(db: Pointer; functionName: PChar; nArg: integer; eTextRep: integer;
      pUserdata: Pointer; xFunc: TxFunc; xStep: TxStep; xFinal: TxFinal): integer; cdecl;
    sqlite3_create_module: Pointer;
    sqlite3_data_count: Pointer;
    sqlite3_db_handle: Pointer;
    sqlite3_declare_vtab: Pointer;
    sqlite3_enable_shared_cache: Pointer;
    sqlite3_errcode: Pointer;
    sqlite3_errmsg: Pointer;
    sqlite3_errmsg16: Pointer;
    sqlite3_exec: Pointer;
    sqlite3_expired: Pointer;
    sqlite3_finalize: Pointer;
    sqlite3_free: Pointer;
    sqlite3_free_table: Pointer;
    sqlite3_get_autocommit: Pointer;
    sqlite3_get_auxdata: Pointer;
    sqlite3_get_table: Pointer;
    sqlite3_global_recover: Pointer;     // Was sqlite3_global_recover(), but that function is deprecated
    sqlite3_interrupt: Pointer;
    sqlite3_last_insert_rowid: Pointer;
    sqlite3_libversion: Pointer;
    sqlite3_libversion_number: Pointer;
    sqlite3_malloc: Pointer;
    sqlite3_mprintf: Pointer;
    sqlite3_open: Pointer;
    sqlite3_open16: Pointer;
    sqlite3_prepare: Pointer;
    sqlite3_prepare16: Pointer;
    sqlite3_profile: Pointer;
    sqlite3_progress_handler: Pointer;
    sqlite3_realloc: Pointer;
    sqlite3_reset: Pointer;
    sqlite3_result_blob: procedure(db: Pointer; value: Pointer; n: integer; ptrDestructor: Pointer); cdecl;
    sqlite3_result_double: procedure(db: Pointer; value: Double); cdecl;
    sqlite3_result_error: procedure(db: Pointer; value: PAnsiChar; n: integer); cdecl;
    sqlite3_result_error16: procedure(db: Pointer; value: PChar; n: integer); cdecl;
    sqlite3_result_int: procedure(db: Pointer; value: integer); cdecl;
    sqlite3_result_int64: procedure(db: Pointer; value: int64); cdecl;
    sqlite3_result_null: procedure(db: Pointer); cdecl;
    sqlite3_result_text: procedure(db: Pointer; value: Pointer; n: integer; ptrDestructor: Pointer); cdecl;
    sqlite3_result_text16: procedure(db: Pointer; value: Pointer; n: integer; ptrDestructor: Pointer); cdecl;
    sqlite3_result_text16be: procedure(db: Pointer; value: Pointer; n: integer; ptrDestructor: Pointer); cdecl;
    sqlite3_result_text16le: procedure(db: Pointer; value: Pointer; n: integer; ptrDestructor: Pointer); cdecl;
    sqlite3_result_value: Pointer;
    sqlite3_rollback_hook: Pointer;
    sqlite3_set_authorizer: Pointer;
    sqlite3_set_auxdata: Pointer;
    sqlite3_snprintf: Pointer;
    sqlite3_step: Pointer;
    sqlite3_table_column_metadata: Pointer;
    sqlite3_thread_cleanup: Pointer;
    sqlite3_total_changes: Pointer;
    sqlite3_trace: Pointer;
    sqlite3_transfer_bindings: Pointer;
    sqlite3_update_hook: Pointer;
    sqlite3_user_data: Pointer;
    sqlite3_value_blob: function(value: Pointer): PAnsiChar; cdecl;
    sqlite3_value_bytes: function(value: Pointer): Integer; cdecl;
    sqlite3_value_bytes16: Pointer;
    sqlite3_value_double: Pointer;
    sqlite3_value_int: Pointer;
    sqlite3_value_int64: Pointer;
    sqlite3_value_numeric_type: Pointer;
    sqlite3_value_text: function(value: Pointer): PAnsiChar; cdecl;
    sqlite3_value_text16: function(value: Pointer): PChar; cdecl;
    sqlite3_value_text16be: function(value: Pointer): PChar; cdecl;
    sqlite3_value_text16le: function(value: Pointer): PChar; cdecl;
    sqlite3_value_type: function(value: Pointer): integer; cdecl;
    sqlite3_vmprintf: Pointer;
    (*
    ** The original API set ends here.  All extensions can call any
    ** of the APIs above provided that the pointer is not NULL.  But
    ** before calling APIs that follow, extension should check the
    ** sqlite3_libversion_number() to make sure they are dealing with
    ** a library that is new enough to support that API.
    *************************************************************************
    *)
    sqlite3_overload_function: Pointer;

    (*
    ** Added after 3.3.13
    *)
    sqlite3_prepare_v2: Pointer;
    sqlite3_prepare16_v2: Pointer;
    sqlite3_clear_bindings: Pointer;

    (*
    ** Added for 3.4.1
    *)
    sqlite3_create_module_v2: Pointer;

    (*
    ** Added for 3.5.0
    *)
    sqlite3_bind_zeroblob: Pointer;
    sqlite3_blob_bytes: Pointer;
    sqlite3_blob_close: Pointer;
    sqlite3_blob_open: Pointer;
    sqlite3_blob_read: Pointer;
    sqlite3_blob_write: Pointer;
    sqlite3_create_collation_v2: Pointer;
    sqlite3_file_control: Pointer;
    sqlite3_memory_highwater: Pointer;
    sqlite3_memory_used: Pointer;
    sqlite3_mutex_alloc: Pointer;
    sqlite3_mutex_enter: Pointer;
    sqlite3_mutex_free: Pointer;
    sqlite3_mutex_leave: Pointer;
    sqlite3_mutex_try: Pointer;
    sqlite3_open_v2: Pointer;
    sqlite3_release_memory: Pointer;
    sqlite3_result_error_nomem: Pointer;
    sqlite3_result_error_toobig: Pointer;
    sqlite3_sleep: Pointer;
    sqlite3_soft_heap_limit: Pointer;
    sqlite3_vfs_find: Pointer;
    sqlite3_vfs_register: Pointer;
    sqlite3_vfs_unregister: Pointer;

    (*
    ** Added for 3.5.8
    *)
    sqlite3_threadsafe: Pointer;
    sqlite3_result_zeroblob: Pointer;
    sqlite3_result_error_code: Pointer;
    sqlite3_test_control: Pointer;
    sqlite3_randomness: Pointer;
    sqlite3_context_db_handle: Pointer;

    (*
    ** Added for 3.6.0
    *)
    sqlite3_extended_result_codes: Pointer;
    sqlite3_limit: Pointer;
    sqlite3_next_stmt: Pointer;
    sqlite3_sql: Pointer;
    sqlite3_status: Pointer;
  end;

implementation

end.

