library saveblob;

uses
  SQLite3Types, SysUtils;

{$R *.res}

var
  sqlite3_api_routines_ptr: Psqlite3_api_routines;

procedure sqlite3_saveblob_func(db: Pointer; n: Integer; args: PPChar); cdecl;
var
  arg0, arg1: PPChar;
  Blob: Pointer;
  Size: Integer;
  FileName, Res: string;
  F: File;
begin
  try
    arg0 := args;
    arg1 := arg0;
    Inc(arg1);
    Blob := sqlite3_api_routines_ptr.sqlite3_value_blob(arg0^);
    Size := sqlite3_api_routines_ptr.sqlite3_value_bytes(arg0^);
    FileName := Trim(sqlite3_api_routines_ptr.sqlite3_value_text16(arg1^));
    ForceDirectories(ExtractFilePath(FileName));
    AssignFile(F, FileName);
    Rewrite(F, 1);
    BlockWrite(F, Blob^, Size);
    CloseFile(F);
    Res := 'success ' + '[' + FileName + ']';
  except
    on E: Exception do
      Res := 'fail ' + '[' + FileName + ']' + ' ' + E.Message;
  end;
  sqlite3_api_routines_ptr.sqlite3_result_text16(db, PChar(Res), Length(Res) * SizeOf(Char), nil);
end;

function sqlite3_extension_init(db: Pointer; errmsg: PPChar; sqlite3_api_routines: Psqlite3_api_routines): Integer; cdecl;
begin
  sqlite3_api_routines_ptr := sqlite3_api_routines;
  sqlite3_api_routines_ptr.sqlite3_create_function(db, 'save_blob', 2, SQLITE_ANY, nil,
    @sqlite3_saveblob_func, nil, nil);
  Result := 0;
end;

exports
  sqlite3_extension_init;

begin
end.
